#ifndef Adt8960H
#define Adt8960H


#if  defined _WINDOWS   ||  defined _Windows
    #define  _MSWINDOWS_
#else
    #undef   _MSWINDOWS_   
#endif 

//0x540---BCB4
#if __BORLANDC__  >  0x540
    #define __FORBCB__
#else
    #undef __FORBCB__
#endif    


#ifdef   _MSWINDOWS_
	#ifdef  ADT8960_EXPORTS
		#define ADTDLLAPI __declspec(dllexport)
	#else
		#define ADTDLLAPI __declspec(dllimport)
	#endif
	#define  CALLTYPE  __stdcall
#else
	#define  ADTDLLAPI
	#define  CALLTYPE 
#endif


#ifdef __FORBCB__
extern "C"
{
#endif
typedef void (*FUNCTION)();

ADTDLLAPI int CALLTYPE adt8960_initial(void);
/********************** Initialize the card *********************** 
Function: initialize motion control card (1) return value> 0, the number of cards 
that adt8960. If 3, then the following card numbers can be 0,1,2, 
respectively; (2) return value = 0, that is not installed adt8960 card; 
(3) return value <0, -1 port drivers not installed, -2 that PCI bridge failure 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE  set_pulse_mode(int cardno,int axis,int value,int logic,int dir_logic);
/******************** Set the output pulse of the work ********************** 
Function: Set the output pulse of the work parameters: cardno axis axis card number (1-6) 
value 0: Pulse + Pulse Mode 1: Pulse + direction mode logic 
0: positive logic pulse 1: Negative logic pulse dir-logic 0: the direction of the output 
signal is logic 1: the direction of the output signal of negative logic 0 
value: the right 1: error default mode: Pulse + direction method, 
 positive logic pulse and direction output signal is logic 
******************************************************************/ 


ADTDLLAPI int CALLTYPE set_limit_mode (int cardno, int axis, int v1, int v2, int logic); 
/************* Set positive / negative direction limit input signal mode settings nLMT ************* 
 Function: Set positive / negative direction limit the input nLMT signal model 
 parameters: cardno card axis axis No. (1-6) v1 0: 1 is the effective 
 limit: Limit is invalid v2 0: negative limit effective 
 1: Negative limit is not valid logic 0: Low Effective 1 
 Level: high effective return value 0: the right 1: error 
 default mode is: is the effective limit the negative limit, active-low 
 note: the signal can not be set to limit valid / invalid. 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE set_stop0_mode (int cardno, int axis, int v, int logic); 
/******************** Set the input mode ********************** 
stop0 Function: Setting stop0 signal valid / invalid and the logic level 
parameters: cardno axis axis card number (1-6) v 0: valid 1: valid 
logic 0: Low Stop 1: high to stop the return value 0: the correct 
one: the default mode error:: Invalid, low stop 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE set_stop1_mode (int cardno, int axis, int v, int logic); 
/********************* Set the input mode ********************* 
stop1 Function: Setting stop1 signal valid / invalid and the logic level 
 parameters: cardno axis axis card number (1-6) v 0: valid 1: valid 
 logic 0: Low Stop 1: high to stop the return value 0: the correct 
 one: the default mode error:: Invalid, low stop 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE get_lib_version (int cardno); 
/************************************************ 
Function: Get the current library version number to return library version is 
the version number 
************************************************/ 

float _stdcall get_hardware_ver (int cardno); 
/*************************** Get hardware version ******************* ******** 
 Function: Get hardware version of the argument: cardno card number to 
 return the value of 1.0: Hardware 1.1 Hardware Second Edition First Edition 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// Driver status check function // 
//------------------------------------------------ ----// 
ADTDLLAPI int CALLTYPE get_status (int cardno, int axis, int * v); 
/************************* For each axis drive state ****************** * *** 
Features: The drive status parameters for single-axis: cardno card axis axis 
No. (1-6) v 0 drive state of the pointer: drive end of the non-0: value of two-byte 
 length value for the return value of 0: right 1: Error 
************************************************** ***************/ 
ADTDLLAPI int CALLTYPE get_inp_status (int cardno, int * v); 
/************************ Driver for the state ******************* 
interpolation **** Features: Get drive status parameters interpolation 
 movement: cardno card status indicators v 0 interpolation: interpolation end of 
the 1: 0 return value is being interpolated: the right 1: Error 
******** ****************************************** ******** *******/ 
//---------------------------------------- -------- ----// 
// Motion parameters set the function // 
//------------------------------------------------ ----// 
ADTDLLAPI int CALLTYPE set_acc (int cardno, int axis, long add); 
/************************** Acceleration setting ******************** * ******** 
 function: to set the value of the acceleration parameters: cardno axis axis card 
 number (1-6) add (1-64000) hardware version 1 Acceleration = add/125 
 return value 0: the correct one: Error 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE set_startv (int cardno, int axis, long speed); 
/************************* Set the initial velocity ******************* * ******** 
function: the initial speed setting parameters: cardno axis axis card number (1-6) 
 speed range (1-2M) return value 0: the right 1: Error 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE set_speed (int cardno, int axis, long speed); 
/*************************** Set the drive speed ****************** ******** 
 Function: Drive speed setting parameters: cardno axis axis card number (1-6) 
 speed range (1-2M) return value 0: the right 1: Error 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE set_command_pos (int cardno, int axis, long pos); 
/************************* Set the logical location ******************** ******** 
functions: 
	logical location to set parameters: cardno axis axis card number (1-6) 
	pos range (-2147483648 ~ +2147483647) 
return value 0: the right 1: Error 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE set_actual_pos (int cardno, int axis, long pos); 
/************************** Set the actual position ******************* ******** 
 Function: set the parameters of the actual location: cardno axis axis 
 card number (1-6) pos range (-2147483648 ~ +2147483647) return value 0: the right 
 1: Error 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE set_symmetry_speed (int cardno, int axis, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************** Set acceleration ******************** * *** 
Function: Set the value of the acceleration parameters: cardno card axis axis 
No. (1-6) lspd speed hspd drive speed tacc start acceleration time acceleration 
mode mode (0: trapezoidal, 1: S-type) vacc acceleration rate of change 
 Return Value 0: Correct 1: Error 
****************************************** ******** ****************/ 
//----------------------- ------------------------- ----// 
// Check the function of motion parameters // 
//--------- --------------------------------------- ----// 
//------------------------------------------------ ----// 
ADTDLLAPI int CALLTYPE get_command_pos (int cardno, int axis, long * pos); 
/************************** For logical location ******************** ******** 
Function: get the axis of the logical location parameters: cardno axis axis 
card number (1-6) pos logical location of the pointer to return value 0: the right 
 1: Error 

************************************************** ****************/ 

ADTDLLAPI int CALLTYPE get_actual_pos (int cardno, int axis, long * pos); 
/************************* Obtain the actual location ******************** * ******* 
 Features: Get the actual position of the axis parameters: cardno axis axis card number 
 (1-6) pos a pointer to the actual location of the return value 0: the right 1: Error 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE get_speed (int cardno, int axis, long * speed); 
/************************** Get drive speed ******************** / 
 Features: get the axis of the current drive speed parameters: cardno axis axis card 
 number (1-6) speed driving speed of the pointer to the current 
 return value 0: the right 1: Error 
************************************************** ***************/ 

ADTDLLAPI int CALLTYPE get_out (int cardno, int number); 
/*************************** For output state ******************* ******** 
Function: Get output status parameters: cardno card number port number 
return value: the current state of specified port, -1 means the parameter error 
*************** *********************************** *************** * / 
//---------------------------------------------- - ----// 
// Driver function // 
//------------------------------------------------ ----/*/ 
ADTDLLAPI int CALLTYPE pmove (int cardno, int axis, long pos); 
/************************* Quantitatively driven ********************** ***** 
 Features: Single-driven quantitative parameters: cardno axis axis card number 
 (1-6) pulse output pulse range (-268 435 455 ~ +268435455 ") 
 > 
 0: positive direction <0: negative direction to return value 0: the right 1: Error 

************************************************** ************/ 


ADTDLLAPI int CALLTYPE continue_move (int cardno, int axis, int dir); 
/************************* Continuous drive ********************** ***** 
 Features: Single continuous drive parameters: cardno axis axis card number (1-6) 
 dir-driven in the direction 0: positive direction 1: return value of 0 negative 
 direction: the right 1: Error 
************************************************** *************/ 

ADTDLLAPI int CALLTYPE dec_stop (int cardno, int axis); 
/************************** Driver deceleration stop ******************** ***** 
functions: slow down the drive to stop the current process 
 parameters: cardno axis axis card number (1-6) return value 0: the right 1: Error 
************************************************** *************/ 

ADTDLLAPI int CALLTYPE sudden_stop (int cardno, int axis); 
/*************************** Driver to immediately stop ****************** * ***** 
functions: the driver to immediately stop the current process 
parameters: cardno axis axis card number (1-6) return value 0: the right 
1: error immediately stop the pulse output is being driven, 
in the acceleration / deceleration driving is also stop immediately. 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE inp_move2 (int cardno, int axis1, int axis2, long pulse1, long pulse2); 
/**************************** Two-axis linear interpolation **************** ********* 
 function: the two-axis linear interpolation motion 
 parameters: cardno card axis1, axis2 axis interpolation in No. pulse1, 
 pulse2 move relative distance range (-8388608 ~ +8388607) 
 returns the value 0: right 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE inp_move3 (int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3); 
/***************************** Three-axis linear interpolation *************** *********** 
 features: three-axis linear interpolation of motion 
 parameters: cardno card number axis1, axis2.axis3 involved interpolation of axis 
 No. Pulse1, pulse2, pulse3 moving relative distance range (-8388608 ~ + 8388607) 
 return value 0: the right 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE inp_move4 (int cardno, int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4); 
/*********************** Features: Four-axis linear interpolation ******************* ***** 
 Features: Four-axis linear interpolation of motion 
 parameters: cardno card number axis1, axis2.axis3, axis4 involved interpolation of axis 
 No. Pulse1, pulse2, pulse3, pulse4 moving relative distance range (-8,388,608 ~ +8388607) 
 Return value 0: Correct 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE inp_move5 (int cardno, int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5); 
/*********************** Features: five-axis linear interpolation ******************* ***** 
Features: five-axis linear interpolation of motion 
parameters: cardno card number axis1, axis2.axis3, axis4, axis5 involved 
 interpolation of axis No. pulse1, pulse2, pulse3, pulse4, 
 pulse5 moving relative distance range (-8388608 ~ +8388607) 
returns the value 0: the right 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE inp_move6 (int cardno, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6); 
/*********************** Features: six-axis linear interpolation ******************* ***** 
 Features: Six-axis linear interpolation motion parameters: cardno card number pulse1, 
 pulse2, pulse3, pulse4, pulse5, pulse6 moving relative distance 
 range (-8,388,608 ~ +8388607) 
return value 0: the right 1: Error 
************************************************** ****************/ 


ADTDLLAPI int CALLTYPE read_bit (int cardno, int number); 
/************************** Input read ****************** *** ******* 
Function: read input parameters: cardno card number input number (0-31) 
return value 0: low 1: Line -1: Error 
************************************************** *****************/ 

ADTDLLAPI int CALLTYPE write_bit (int cardno, int number, int value); 
/*************************** Output point of reading ***************** * *********** 
 Function: read the output point parameters: cardno Card number output point (0-15) 
 value 0: Low 1: High return value 0: the right 1: Error 
************************************************** ******************/ 

ADTDLLAPI int CALLTYPE set_suddenstop_mode (int cardno, int v, int logic); 
/**************************** Hardware stop mode ****************** ******** 
 Function: hardware stop mode to set parameters: cardno card number v 
 0: Invalid 1: Valid logic 0: active low 1: high effective return value 0: the right 
 1: Stop signal hardware error fixed using the J2 terminal board 33 pin (IN31) 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE set_io_mode (int cardno, int v1, int v2); 
/*************************** Set the input and output ***************** * ************ 
Function: Set the input and output parameters: v1 0: 8 points ahead is defined as 
the input 1: 8 points ahead is defined as the output v2 0: 8 points behind is defined 
as the input 1: 8 points behind the return value of 0 is defined as output: the right 
1: Error 
 Note: When the IO point when used as an output point and can also read input status 
************************************************** *******************/ 

ADTDLLAPI int CALLTYPE get_delay_status (int cardno); 
/************************** For delay status ******************* * ********** 
 Function: get delayed state parameters: cardno card number to 
return the value 0: 1 end delay: delay in progress 
************************************************** ******************/ 

ADTDLLAPI int CALLTYPE set_delay_time (int cardno, long time); 
/*************************** Set the delay time ***************** * ************ 
Function: set the delay time parameter: cardno Card time delay time 
return value 0: the correct one: the wrong time unit 1/8us 
************************************************** *******************/ 

//*********************************************// 
// Composite drive type // 
//*********************************************// 
ADTDLLAPI int CALLTYPE symmetry_relative_move (int cardno, int axis, long pulse, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ******* 
* Function: the relative motion axis linear interpolation with reference to the current 
position to accelerate the quantitative parameters of mobile *: cardno-Card No. 
axis axis --- pulse - pulse lspd --- low hspd --- high-speed tacc - - acceleration 
 time (unit: seconds) vacc --- acceleration rate of change of 
 mode --- mode (0: trapezoid, 1: S curve) return value 0: the right 1: Error 
************************************************** *******/ 

ADTDLLAPI int CALLTYPE symmetry_absolute_move (int cardno, int axis, long pulse, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ******** 
* Function: absolute motion axis linear interpolation, zero reference position to 
accelerate the move * quantitative parameters: cardno-Card No. 
 axis axis --- pulse - pulse lspd --- low hspd --- high-speed tacc - - acceleration 
 time (unit: seconds) vacc --- acceleration change 
 rate mode --- Mode (0: trapezoid, 1: S curve) return value 0: the right 1: Error 
************************************************** ********/ 

ADTDLLAPI int CALLTYPE symmetry_relative_line2 (int cardno, int axis1, int axis2, long pulse1, long pulse2, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ********* 
* Features: two-axis linear interpolation relative motion, reference the current location, 
 in order to speed up linear interpolation * Parameters: cardno-card number axis1 --- No. 
 1 axis2 --- axle shaft No. 2 pulse1 - Pulse 1 pulse2 - Pulse 2 
 lspd --- tacc --- low hspd --- high-speed acceleration time (unit: seconds) 
 vacc --- acceleration rate of change of mode --- mode (0: trapezoid, 1: S curve) 
 return value 0: correct 1: Error 
************************************************** *********/ 

ADTDLLAPI int CALLTYPE symmetry_absolute_line2 (int cardno, int axis1, int axis2, long pulse1, long pulse2, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ********** 
* Features: two-axis linear interpolation of absolute motion, zero reference position to 
speed up linear interpolation * Parameters: cardno-card number axis1 --- No. 1 axis 
2 --- shaft axis No. 2 pulse1 - Pulse 1 pulse2 - Pulse 2 lspd --- tacc --- low 
hspd --- high-speed acceleration time (unit: seconds) vacc --- acceleration rate of 
change of mode --- mode (0: trapezoid, 1: S curve) return value 0: correct 1: Error 
************************************************** **********/ 

ADTDLLAPI int CALLTYPE symmetry_relative_line3 (int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* *********** 
* Features: three-axis linear interpolation relative motion, the light of the current 
location, in order to speed up linear interpolation * Parameters: cardno-card number 
axis1 --- Shaft No. 1 axis2 --- No. 2 axis3 --- axle shaft No. 3 pulse1 - Pulse 1 
pulse2 - Pulse 2 pulse3 - Pulse 3 lspd --- tacc --- low hspd --- high-speed acceleration 
time (unit: seconds) vacc --- acceleration rate of change of mode --- 
mode (0: ladder, 1: S curve) return value 0: the right 1: Error 
************************************************** *************/ 

ADTDLLAPI int CALLTYPE symmetry_absolute_line3 (int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ************* 
Features: Three-axis linear interpolation of absolute motion, zero reference position 
to accelerate in a straight line interpolation parameters: cardno-card number 
axis1 --- Shaft No. 1 axis2 --- No. 2 axis3 --- axis shaft No. 3 pulse1 - Pulse 1 
 pulse2 - Pulse 2 pulse3 - pulse 3 lspd --- tacc --- low hspd --- high-speed acceleration 
 time (unit: seconds) vacc --- acceleration rate of change of mode --- mode 
 (0: trapezoid, 1: S curve) return value 0: the right 1: Error 
************************************************** **************/ 

ADTDLLAPI int CALLTYPE symmetry_relative_line4 (int cardno, int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* *************** 
* Features: Four-axis linear interpolation relative motion, the light of the current 
location, in order to speed up linear interpolation * Parameters: cardno-card number 
axis1 --- Shaft No. 1 axis2 --- No. 2 axis3 --- axle shaft No. 3 axis4 --- Shaft No. 4 
pulse1 - Pulse 1 pulse2 - Pulse 2 pulse3 - Pulse 3 pulse4 - Pulse 4 lspd --- tacc --- low 
 hspd --- high-speed acceleration time (unit: seconds) vacc - - the acceleration rate of 
 change of mode --- mode (0: trapezoid, 1: S curve) 
************************************************** **************/ 

ADTDLLAPI int CALLTYPE symmetry_absolute_line4 (int cardno, int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long lspd, long hspd, double tacc, long vacc, int mode); 
/************************************************* ************** 
* Features: Four-axis linear interpolation absolute motion, zero reference position to acceleration and deceleration in a straight line interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoid, 1: S curve) 
************************************************** **************/ 

ADTDLLAPI int CALLTYPE symmetry_relative_line5 (int cardno, int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long lspd, long hspd, double tacc, long vacc, int mode); 
/***************** Axis linear interpolation relative motion **************** 
* Function: reference to the current position to acceleration and deceleration in a straight line interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
axis5 --- No. 5 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 

ADTDLLAPI int CALLTYPE symmetry_absolute_line5 (int cardno, int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long lspd, long hspd, double tacc, long vacc, int mode); 
/***************** Symmetry axis linear interpolation absolute motion **************** 
* Function: zero reference position to symmetric acceleration and deceleration in a straight line interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
axis5 --- No. 5 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 

ADTDLLAPI int CALLTYPE symmetry_relative_line6 (int cardno, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long lspd, long hspd, double tacc, long vacc, int mode); 
/***************** Six-axis linear interpolation relative motion **************** 
* Function: reference to the current position to acceleration and deceleration in a straight line interpolation 
* Parameters: 
      cardno-Card 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
pulse6 - Pulse 6 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 

ADTDLLAPI int CALLTYPE symmetry_absolute_line6 (int cardno, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long lspd, long hspd, double tacc, long vacc, int mode); 
/***************** Six-axis symmetric linear interpolation absolute motion **************** 
* Function: zero reference position to symmetric acceleration and deceleration in a straight line interpolation 
* Parameters: 
      cardno-card number 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
pulse6 - Pulse 6 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
      mode --- mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 

//------------------------------------------------ ----// 
// 2008.10.6 // 
//------------------------------------------------ ----// 
ADTDLLAPI int CALLTYPE set_acac (int cardno, int axis, long value); 
/******************* Functions: plus / minus the rate of change speed settings ******************* * 
cardno Card 
No. axis axis 
value K value (1-65535) 
The actual rate of change 1000000 / k 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE set_ad_mode (int cardno, int axis, int mode); 
/********************* Features: Add / decelerating way of setting ******************* *** 
cardno Card 
No. axis axis (1-4) 
mode 0: linear acceleration / deceleration 1: S curve acceleration / deceleration 
Return value 0: Correct 1: Error 
Default mode: linear acceleration / deceleration 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE get_ad (int cardno, int axis, long * ad); 
/******************* Function: get the axis of the current acceleration ********************* 
cardno Card 
No. axis axis 
acceleration of the pointer to the current ad 
Return value 0: Correct 1: Error 
Data-driven acceleration of the unit and set the same value A 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// External signal driver // 
//------------------------------------------------ ----// 
ADTDLLAPI int CALLTYPE manual_continue (int cardno, int axis); 
/******************* Function: external signal continuous drive ********************* 
cardno Card 
No. axis axis 
Return value 0: Correct 1: Error 
Note: (1) a continuous pulse, but the driver did not immediately need to wait until the external signal level changes 
(2) you can use the normal buttons, you can also take over the wheel 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE manual_pmove (int cardno, int axis, long pos); 
/******************* Function: external signal quantitatively driven ********************* 
cardno Card 
No. axis axis 
Return value 0: Correct 1: Error 
Note: (1) a quantitative pulse, but the driver did not immediately need to wait until the external signal level changes 
(2) you can use the normal buttons, you can also take over the wheel 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE manual_disable (int cardno, int axis); 
/*********************** Close external signal drives enable ******************** *** 
Function: Close external drive enable signal 
Parameters: 
cardno Card 
No. axis axis (1-6) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// Position latch // 
//------------------------------------------------ ----// 
ADTDLLAPI int CALLTYPE set_lock_position (int cardno, int axis, int mode, int regi, int logical); 
/**************************** Position latch set function **************** ****** 
Function: Set the signal function in place, lock all the axes of the logical location and actual location 
Parameters: 
axis-reference axis 
mode-latch mode | 0: Invalid 
| 1: Effective 
regi-counter mode | 0: logical location 
| 1: actual position 
logical-Level Signal | 0: rising edge 
| 1: falling 
Return value 0: Correct 1: Error 
Note: Use the specified axis axis of the IN signal as a trigger signal 
************************************************** *****************/ 

ADTDLLAPI int CALLTYPE get_lock_status (int cardno, int axis, int * v); 
/************************* Access latch state ******************** *** 
Function: Get the status latch operations 
Parameters: 
cardno Card 
No. axis axis (1-6) 
v 0 | is not running latch operation 
1 | latch operation performed 
Return value 0: Correct 1: Error 
Description: The position of the latch function can capture whether the implementation of the 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE get_lock_position (int cardno, int axis, long * pos); 
/************************** Get locked position ******************* ******* 
Features: access to the locked position 
Parameters: 
cardno Card 
No. axis axis (1-6) 
latch position pos 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE clr_lock_status (int cardno, int axis); 
/************************** Clear lock ********************* ***** 
Function: Clear Lock 
Parameters: 
cardno Card 
No. axis axis (1-6) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

//------------------------------------------------ ----// 
// Hardware cache // 
//------------------------------------------------ ----// 
ADTDLLAPI int CALLTYPE fifo_inp_move1 (int cardno, int axis1, long pulse1, long speed); 
/************************** Uniaxial cache ******************** ****** 
Function: Single Cache 
Parameters: 
cardno Card 
axis1 axis number (1-6) 
pulse1 cache pulse 
speed cache speed 
Return value 0: Correct 1: Error 
Note: Total 2048 buffer space, each occupied by three uniaxial instruction cache space, cache 682 instructions 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE fifo_inp_move2 (int cardno, int axis1, int axis2, long pulse1, long pulse2, long speed); 
/************************** Two axes cache ******************** ****** 
Features: Two-axis cache 
Parameters: 
cardno Card 
axis1 axis number (1-6) 
axis2 axis number (1-6) 
pulse1 cache of pulses 
pulse2 cache of pulses 
speed cache speed 
Return value 0: Correct 1: Error 
Note: Total 2 048 cache space occupied by each of the two 4-axis cache instruction space, instruction cache 512 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE fifo_inp_move3 (int cardno, int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long speed); 
/************************** Axis cache ******************** ****** 
Features: Three-axis cache 
Parameters: 
cardno Card 
axis1 axis number (1-6) 
axis2 axis number (1-6) 
axis3 axis number (1-6) 
pulse1 cache of pulses 
pulse2 cache of pulses 
pulse3 cache of pulses 
speed cache speed 
Return value 0: Correct 1: Error 
Note: Total 2 048 cache space occupied by each instruction cache 5 triaxial space, instruction cache 409 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE fifo_inp_move4 (int cardno, int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long speed); 
/************************** Four-axis cache ******************** ****** 
Features: Four-axis cache 
Parameters: 
cardno Card 
axis1 axis number (1-6) 
axis2 axis No. (1-6) 
axis3 axis number (1-6) 
axis4 axis number (1-6) 
pulse1 cache of pulses 
pulse2 cache of pulses 
pulse3 cache of pulses 
pulse4 cache of pulses 
speed cache speed 
Return value 0: Correct 1: Error 
Note: Total 2 048 cache space occupied by each four-axis instruction cache 6 space, instruction cache 341 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE fifo_inp_move5 (int cardno, int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long speed); 
/************************** Axis cache ******************** ****** 
Features: five-axis cache 
Parameters: 
cardno Card 
axis1 axis number (1-6) 
axis2 axis number (1-6) 
axis3 axis No. (1-6) 
axis4 axis number (1-6) 
axis5 axis number (1-6) 
pulse1 number of pulses cache 
pulse2 cache of pulses 
pulse3 cache of pulses 
pulse4 cache of pulses 
pulse5 cache of pulses 
speed cache speed 
Return value 0: Correct 1: Error 
Note: Total 2 048 cache space occupied by each axis 7 instruction cache space, cache 292 instructions 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE fifo_inp_move6 (int cardno, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long speed); 
/************************** Six-axis cache ******************** ****** 
Features: Six-axis cache 
Parameters: 
cardno Card 
pulse1 cache of pulses 
pulse2 cache of pulses 
pulse3 cache of pulses 
pulse4 cache of pulses 
pulse5 cache of pulses 
pulse6 cache of pulses 
speed the speed of the cache 
Return value 0: Correct 1: Error 
Note: Total 2 048 cache space occupied by each six-axis cache directive 8 space, instruction cache 256 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE reset_fifo (int cardno); 
/************************** Reset cache ******************** ****** 
Function: Clear Cache 
Parameters: 
cardno Card 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE read_fifo_count (int cardno, int * value); 
/************************** Read caching few ******************* *** 
Function: read cache the number of orders placed into the left how many non-implementation 
Parameters: 
cardno Card 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE read_fifo_empty (int cardno); 
/************************** Read cache state ******************* *** 
Function: read cache is empty 
Parameters: 
cardno Card 
Return value 0: non-empty 1: Empty 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE read_fifo_full (int cardno); 
/************************** Read cache state ******************* *** 
Function: read cache is full, full will no longer have the data after 
Parameters: 
cardno Card 
Return value 0: less than 1: Moon 
************************************************** ****************/ 

//************************************************ **************************// 
// ************* ************* Manual deceleration function // 
// First need to set the manual deceleration mode // 
// Valid when the manual deceleration mode, set the manual deceleration point pos1 // 
// Set origin offset pos2 // 
// Set the manual deceleration point and the speed (low speed) endspeed // 
// Manual deceleration movement: Movement to the deceleration point pos1 automatically slow down to endspeed run // 
// To speed endspeed search for the origin signal, origin of the signal the need for external signal trigger (stop0 the low level trigger) // 
// When the origin of the signal is triggered, the campaign immediately after the origin offset pos2 stop // 
//************************************************ **************************// 

ADTDLLAPI int CALLTYPE set_dec_mode (int cardno, int axis, int mode); 
/************************** Set manual deceleration mode ******************* ******* 
Function: Set the manual deceleration mode 
Parameters: 
cardno Card 
No. axis axis (1-6) 
mode manual mode 0 is invalid an effective reduction 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE set_dec_pos1 (int cardno, int axis, long pos); 
/************************** Set manual deceleration point ******************* ******* 
Function: Set the manual deceleration point 
Parameters: 
cardno Card 
No. axis axis (1-6) 
pos deceleration point 
Return value 0: Correct 1: Error 
Description: to the deceleration of the deceleration point automatically to the specified low-speed movement, looking for the origin of the trigger signal, 
If you do not find the trigger signal, has been movement at this rate will continue until the end of the exercise 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE set_dec_pos2 (int cardno, int axis, long pos); 
/************************** Specified offset ***************** manual deceleration ********* 
Function: the origin offset 
Parameters: 
cardno Card 
No. axis axis (1-6) 
pos surplus position 
Return value 0: Correct 1: Error 
Description: Movement of the offset the need for external signal trigger, trigger the low signal stop0 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE clr_dec_status (int cardno, int axis); 
/************************** Clear manual deceleration ******************* ******* 
Function: remove manual deceleration 
Parameters: 
cardno Card 
No. axis axis (1-6) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE get_dec_status (int cardno, int axis, int * sta); 
/************************** For manual deceleration ******************* ******* 
Function: get manual deceleration 
Parameters: 
cardno Card 
No. axis axis (1-6) 
sta deceleration 
0: Searching 
1: search completed 
2: The movement has to stop, slow down point not found 
3: does not meet the actual migration 
4: Search deceleration point during the servo Close 
5: deceleration point has been found to offset movement is not in place (which may limit trigger, etc.) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 

ADTDLLAPI int CALLTYPE set_end_speed (int cardno, int axis, long speed); 
/**************** Functions: speed set trailing ************** 
Function: Set the manual deceleration point, the low speed signals to find the origin 
Parameters: 
cardno Card 
No. axis axis (1-6) 
speed range (1-2M) 
Return value 0: Correct 1: Error 
Note: If the manual deceleration point pos1 not found after the trigger signal (slow signal origin), has been movement will continue at this rate 
************************************************/ 
#ifdef __FORBCB__

}                         
#endif